 aR  w V mc9      h	 oU     nSystem-wide$PAGEWIDTH(150)
%SET (PCAT, 1)
%SET (AlwaysSave8087Regs, 0)

    NAME CpTask

; This is cp.task.asm~text~
; This contains all the multi-tasking routines

$NOLIST
$INCLUDE (``OsIncs`CpConst~Inc~)
$NOLIST

DGROUP GROUP DATA
CGROUP GROUP CODE
;SYSDEP_DGROUP GROUP SYSDEP_DATA

    PUBLIC Reschedule, TimerInterrupt, InitMultiTasking
    PUBLIC CpSignal, CpWait, CpSend
    PUBLIC CpReceive, CpCreateProcess, CpDeleteProcess
    PUBLIC CpDelay, CpWhoAmI, CpSetPriority, CpCreateSemaphore
    PUBLIC CpDeleteSemaphore
    PUBLIC OsProcessQ, OsSemaQ, osCurrentPid, bootTrace, TellMessageWaiters
    PUBLIC SysCounter, GpibJump, GpibOff, GpibSeg
    PUBLIC OsFreeMemQ, OsAllocMemQ 
    PUBLIC FakeLdTblSlot

    EXTRN IntAllocate:FAR, InitMemMgr:FAR
    EXTRN OsInsertIntoQ:FAR, OsInitQcb:FAR, OsRemoveFromQ:FAR, OsNewQElement:FAR
    EXTRN CpFree:FAR
    EXTRN CpSystemTick:FAR

    EXTRN EmsSaveContext: NEAR, EmsSetActiveRam: NEAR, EmsSwapTasksEmsRam: NEAR
    EXTRN IntCpSetActiveRomSlot: NEAR, EmsSetProcessRam: NEAR

; variables

DATA SEGMENT PUBLIC 'DATA'

    EXTRN curSlot: BYTE, emsValid: BYTE, emsContextSize: WORD

dummyError DW ?               ; dummy error code

osProcessQ QcbType <>         ; Q of all processes
osSemaQ QcbType <>            ; Q of all semaphores
osCurrentPid DW ?             ; THE currentPid
loopPid DW ?                  ; temporary process that just loops
bootTrace DB ?                ; character of boot device
busyStackOff DW ?
busyStackSeg DW ?             ; address of busy stack start
sysCounter DD ?               ; system counter
timedProcesses DW ?           ; # processes waiting on time
gpibJump DB ?                 ; long jump instr.
gpibOff DW ?                  ; offset of current gpib driver
gpibSeg DW ?                  ; segment of current gpib driver
pFontTableOff DW ?            ; pointer to prom font table
pFontTableSeg DW ?            ; pointer to prom font table
nextpidToSchedule DW ?        ; used by rescheduler
bubbleSema DW ?               ; bubble lock semaphore
pid8087 DW ?                  ; Error table used while booting
dummyWords DW 4 DUP (?)       ; not used
osFreeMemQ QcbType <>         ; Free memory list
osAllocMemQ QcbType <>        ; Alocate memory list

;needToReschedule DB ?         ; Does system tick need to reschedule ?


DATA ENDS

Stack SEGMENT WORD STACK 'STACK'
Stack ENDS
$EJ

CODE SEGMENT BYTE PUBLIC 'CODE'
    ASSUME CS:CGROUP, DS:DGROUP

intMaskReg       EQU   021H          ; Mask register for interrupt controller
maskOffAllInts   EQU   0FFH

DataFrame        DW Data             ; segment of data group
FakeLoadTable    DB 30 DUP (0)       ; fake load table for processes
FakeLdTblSlot    DB  1 DUP (0FEH)    ; This will be set in DoBoot (in SysDep)
FakeLdTblEmsGrps DB  1 DUP (1)       ; Needed for OsForkProcess


    EXTRN tickGranularity:WORD

%IF (%PCAT) THEN
(
;    PopFlags: PROCEDURE 
;
; This routine is required on the 286 in order to pop flags from
; the stack.  This is due to a 286 bug.  
;
PopFlags PROC NEAR
  IRET
PopFlags ENDP
)
FI


;    FreeMe : PROCEDURE (sel)
;
;    This will free the block at sel:0.  The error
;    from CpFree is ignored.

sel EQU WORD PTR [BP+4]

FreeMe PROC NEAR
    PUSH BP
    MOV BP, SP
    PUSHF

    PUSH sel
    XOR AX, AX                 ; sel:0
    PUSH AX

    PUSH CS:DataFrame
    MOV AX, OFFSET dummyError  ; @dummyError
    PUSH AX

    STI
    CALL CpFree                ; should interrupts really be enabled ???

%IF (%PCAT) THEN
  (
    PUSH CS
    CALL PopFlags
  )
ELSE
  (
    POPF                        ; restore flags
  )
FI
    POP BP
    RET 2
FreeMe ENDP
PURGE sel

;    PopStart
;
;    These are the first instructions a new process will execute.
;    This runs the after the return of SwapTaskRoutines.

PopStart PROC FAR

    POP DS                     ; initialize DS
    POP ES                     ; initialize ES
    IRET
PopStart ENDP

$EJ
;    HeadOfProcessQ
;
;    This will return in DS the first process in OsProcessQ
;    This changes DS and BX

HeadOfProcessQ PROC NEAR

    MOV DS, CS:DataFrame
    MOV BX, OFFSET OsProcessQ
    MOV DS, DS:[BX].headOfQ         ; pid := OsProcessQ.headOfQ

    RET
HeadOfProcessQ ENDP


;    DecTimedProcesses
;
;    This will decrement the variable timedProcesses.
;    This uses the registers ES AND BX

DecTimedProcesses PROC NEAR

    PUSH ES
    MOV ES, CS:DataFrame
    MOV BX, OFFSET timedProcesses
    DEC WORD PTR ES:[BX]
    POP ES

    RET
DecTimedProcesses ENDP


;    IncTimedProcesses
;
;    This will inccrement the variable timedProcesses.
;    This uses the registers ES AND BX

IncTimedProcesses PROC NEAR

    PUSH ES
    MOV ES, CS:DataFrame
    MOV BX, OFFSET timedProcesses
    INC WORD PTR ES:[BX]
    POP ES

    RET
IncTimedProcesses ENDP
$EJ
;    SemaphoreExists : PROCEDURE (sid) BOOLEAN;
;        DCL sid SidType
;
;    This will indicate whether a semaphore exists by
;    checking its id code

sid EQU WORD PTR [BP+4]              ; first param

SemaphoreExists PROC NEAR
    PUSH BP
    MOV BP, SP

    MOV AL, TRUE
    MOV ES, sid
    CMP ES:scbIdCode, semaphoreIdCode ; RETURN (scb.idCode = semaphoreIdCode)
    JE SemaExDone

    MOV AL, FALSE

SemaExDone:
    POP BP
    RET 2
SemaphoreExists ENDP
PURGE sid

;    ProcessExists : PROCEDURE (pid) BOOLEAN;
;        DCL pid PidType
;
;    This will indicate whether a process exists by
;    checking its id code

pid EQU WORD PTR [BP+4]             ; first param

ProcessExists PROC NEAR
    PUSH BP
    MOV BP, SP

    MOV AL, TRUE
    MOV ES, pid
    CMP ES:pcbIdCode, processIdCode ; RETURN (pcb.idCode = processIdCode)
    JE ProcessExDone

    MOV AL, FALSE

ProcessExDone:
    POP BP
    RET 2
ProcessExists ENDP
PURGE pid
$EJ
;    FirstWaitingProcess : PROCEDURE (sid) PidType;
;        DCL sid SidType;
;
;    This will return the pid of the first process which is
;    waiting on this semaphore.  Null will be returned if no
;    process is waiting

sid EQU WORD PTR [BP+6]             ; first param

; let DS be pid

FirstWaitingProcess PROC NEAR
    PUSH DS
    PUSH BP
    MOV BP, SP

    CALL HeadOfProcessQ             ; DS := OsProcessQ.headOfQ

    MOV ES, sid
    CMP ES:scbCount, 0              ; IF scb.count = 0 THEN RETURN (nullWord)
    MOV AX, nullWord
    JE FirstWaitReturnNull

    MOV DX, ES                      ; DX := sid to test for

    MOV AX, DS                      ; init AX
FirstWaitTopOfLoop:
    MOV DS, AX
    CMP AX, nullWord                ; DO WHILE pid <> nullWord;
    JE FirstWaitReturnNull

    MOV AL, DS:pcbState
    AND AL, timedMask
    CMP AL, semaphoreWait           ;    IF ((pcb.state AND timedMask) = semaphoreWait) 
    JNE FirstWaitNext

    CMP DS:pcbSource, DX            ;    AND (pcb.source = sid) THEN DO;
    JE FirstWaitFound               ;        RETURN (pid)

FirstWaitNext:
    MOV AX, DS:next                 ;    pid := pcb.next
    JMP SHORT FirstWaitTopOfLoop

FirstWaitFound:
    MOV AX, DS                      ;        RETURN (pid)

FirstWaitReturnNull:
                                    ; AX should already have null.
FirstWaitDone:   
    POP BP
    POP DS
    RET 2
FirstWaitingProcess ENDP
PURGE sid
$EJ
;    ComputeTime : PROCEDURE (time) WORD
;
;    This will return the number of ticks to wait

time EQU WORD PTR [BP+4]

ComputeTime PROC NEAR
    PUSH BP
    MOV BP, SP

    MOV AX, time
    MOV CX, CS:tickGranularity
    ADD AX, CX
    DEC AX              ; RETURN ((time + timeSlice - 1) / timeSlice)
    XOR DX, DX
    DIV CX

    POP BP
    RET 2
ComputeTime ENDP
PURGE time


;    CpWhoAmI : PROCEDURE PidType CLEAN
;
;    This will return the value of the current pid

CpWhoAmI PROC FAR
    PUSH DS

    MOV DS, CS:DataFrame
    MOV AX, DS:osCurrentPid

    POP DS
    RET
CpWhoAmI ENDP
$EJ
;    AnyMessage : PROCEDURE (sourcePid, messageType) MidType;
;        DCL sourcePid PidType;
;        DCL messageType WORD;
;
;    This will search the message queue of a pcb to
;    determine if there are any messages there from a
;    given pid and a given type.  If a match is found then mid
;    is returned, else null.

messageType EQU WORD PTR [BP+6]     ; second param
sourcePid EQU WORD PTR [BP+8]       ; first param

; let DS be mid

AnyMessage PROC NEAR
    PUSH DS
    PUSH BP
    MOV BP, SP

    CALL CpWhoAmI
    MOV DS, AX                      ; DS := curPcb.headOfQ
    MOV DS, DS:pcbHeadOfQ

    MOV CX, messageType             ; CX := messageType
    MOV DX, sourcePid               ; DX := sourcePid

AnyMessTopOfLoop:
    MOV AX, DS
    CMP AX, nullWord                ; DO WHILE mid <> nullWord
    JE AnyMessReturnNull

    CMP DS:mcbSourcePid, DX         ;     IF ((mcb.sourcePid = sourcePid)
    JE AnyMessTest2
    CMP DX, nullWord                ;        OR (sourcePid = nullWord))
    JNE AnyMessNext

AnyMessTest2:
    CMP CX, nullWord                ;     AND ((messageType = nullWord)
    JE AnyMessFound
    CMP CX, DS:mcbMessageType       ;        OR (messageType = mcb.messageType)) THEN
    JE AnyMessFound

AnyMessNext:
    MOV DS, DS:next
    JMP SHORT AnyMessTopOfLoop

AnyMessFound:
    MOV AX, DS                      ;         RETURN (mid)

AnyMessReturnNull:                  ;  AX should already have null
    POP BP
    POP DS
    RET 4
AnyMessage ENDP
PURGE messageType, sourcePid
$EJ
;    AddToReadyQ : PROCEDURE (pid)
;
;    This will add a pcb to the process q.  It is added so
;    that it will be the last in the group of equal priority.

pid EQU WORD PTR [BP+6]

; let DS be tempPid
; let DX be prevPid
; let CL be pcb.priority

AddToReadyQ PROC NEAR
    PUSH DS
    PUSH BP
    MOV BP, SP

    MOV DS, pid
    MOV CL, DS:pcbPriority          ; CL := pcb.priority

    CALL HeadOfProcessQ             ; DS, tempPid := OsProcessQ.headOfQ

    MOV DX, nullWord                ; prevPid := nullWord

    MOV AX, DS
AddToTopOfLoop:
    MOV DS, AX
    CMP AX, nullWord                ; DO WHILE tempPid <> nullWord;
    JE AddToLoopExit

    CMP DS:pcbPriority, CL          ;     IF tempPcb.priority > pcb.priority THEN GOTO LoopExit
    JA AddToLoopExit

    MOV DX, DS                      ;     prevPid := tempPid;
    MOV AX, DS:next                 ;     tempPid := tempPcb.next
    JMP SHORT AddToTopOfLoop

AddToLoopExit:
    MOV AX, SEG OsProcessQ
    PUSH AX                         ; @OsProcessQ
    MOV AX, OFFSET OsProcessQ
    PUSH AX

    PUSH DX                         ; prevPid

    PUSH pid                        ; pid

    CALL OsInsertIntoQ

    POP BP
    POP DS
    RET 2
AddToReadyQ ENDP
PURGE pid
$EJ
;    FirstReadyProcess : PROCEDURE PidType
;
;    This will return the first process on the process
;    queue that is ready.

; let DS be pid

FirstReadyProcess PROC NEAR
    PUSH DS

    CALL HeadOfProcessQ             ; DS := OsProcessQ.headOfQ

    MOV AX, DS
FirstReadyTopOfLoop:
    MOV DS, AX
    CMP AX, nullWord                ; DO WHILE pid <> nullWord
    JE FirstReadyReturn

    CMP DS:pcbState, readyState     ;     IF pcb.state = readyState THEN RETURN (pid)
    JE FirstReadyReturn

    MOV AX, DS:next                 ;     pid := pcb.next
    JMP SHORT FirstReadyTopOfLoop

FirstReadyReturn:
    MOV AX, DS                      ; RETURN (pid)

    POP DS
    RET
FirstReadyProcess ENDP
$EJ
;    RoundRobinProcess : PROCEDURE (pid) PidType
;        DCL pid PidType
;
;    This will return the next round robin process
;    relative to the current pid.  It looks first at the
;    processes of equal priority and if none are ready then
;    then it takes the first ready process.

pid EQU WORD PTR [BP+6]

; let DS be pid
; let ES be FirstReadyProcess

RoundRobinProcess PROC NEAR
    PUSH DS
    PUSH BP
    MOV BP, SP

    CALL FirstReadyProcess
    MOV ES, AX                      ; ES = real first ready (this should never be null)

    MOV DS, pid                     ; DS := pid

    MOV DS, DS:next                 ; pid := pcb.next

    MOV AX, DS
RoundRobTopOfLoop:
    MOV DS, AX
    CMP AX, nullWord                ; DO WHILE pid <> nullWord (this should never be null)
    JE RoundRealFirst

    CMP DS:pcbState, readyState     ;     IF pcb.pcbState = readyState THEN EXIT
    JE RoundRobFirstReady

    MOV AX, DS:next                 ;     pid := pid.next
    JMP SHORT RoundRobTopOfLoop

RoundRobFirstReady:                 ; DS = curPid
    MOV AL, DS:pcbPriority
    CMP AL, ES:pcbPriority          ; IF curPcb.priority <= realPcb.priority THEN RETURN(curPid)
    MOV AX, DS
    JBE RoundRobReturn

RoundRealFirst:
    MOV AX, ES                      ; ELSE RETURN (real)

RoundRobReturn:
    POP BP
    POP DS
    RET 2
RoundRobinProcess ENDP
PURGE pid
$EJ
;    TellWaiters : PROCEDURE (sid)
;        DCL sid SidType
;
;    This will return an error to all those processes waiting
;    on a semaphore that has just been deleted.  Each of these
;    is put back into the ready state with an error of eSemaNotExist.

sid EQU WORD PTR [BP+6]
; let DS be curPid and DX be sid

TellWaiters PROC NEAR
    PUSH DS
    PUSH BP
    MOV BP, SP

    CALL HeadOfProcessQ             ; DS := OsProcess.headOfQ

    MOV DX, sid                     ; DX := sid

TellWaitTopOfLoop:
    MOV AX, DS
    CMP AX, nullWord                ; DO WHILE curPid <> nullWord
    JE TellWaitDone

    MOV AL, DS:pcbState
    MOV AH, AL                      ;     save state in AH
    AND AL, timedMask
    CMP AL, semaphoreWait           ;     IF ((curPcb.state AND timedMask) = semaphoreWait)
    JNE TellWaitNext
    CMP DS:pcbSource, DX            ;     AND (curPcb.source = sid) THEN DO;
    JNE TellWaitNext

    LES BX, DWORD PTR DS:pcbPErrorOff
    MOV WORD PTR ES:[BX], eSemaNotExist ;     error := eSemaNotExist

    CMP AH, timedSemaphoreWait      ;         IF curPcb.state = timedSemaphoreWait THEN DO;
    JNE TellWait10

    CALL DecTimedProcesses          ;             timedProcesses := timedProcesses - 1;

TellWait10:
    MOV DS:pcbState, readyState     ;         curPcb.state := readyState

TellWaitNext:
    MOV DS, DS:next                 ;     curPid := curPcb.next
    JMP SHORT TellWaitTopOfLoop

TellWaitDone:
    POP BP
    POP DS
    RET 2
TellWaiters ENDP
PURGE sid
$EJ
;    TellMessageWaiters : PROCEDURE (pid, exitCode) CLEAN;
;        DCL pid PidType;
;        DCL exitCode WORD;
;
;    This will see if any processes are waiting on a
;    message from a given pid.  If so they will be given an error
;    of eProcNotExist and will be placed back into the ready state.

exitCode EQU WORD PTR [BP+8]
pid EQU WORD PTR [BP+10]

; let DS be curPid and DX be pid

TellMessageWaiters PROC FAR
    PUSH DS
    PUSH BP
    MOV BP, SP
    PUSHF

    CLI

    CALL HeadOfProcessQ             ; DS := OsProcessQ.headOfQ

    MOV DX, pid                     ; DX := pid

TellMessTopOfLoop:
    MOV AX, DS
    CMP AX, nullWord                ; DO WHILE curPid <> nullWord
    JE TellMessDone

    MOV AL, ds:pcbState
    MOV AH, AL
    AND AL, timedMask
    CMP AL, messageWait            ;     IF ((curPcb.state AND timedMask) = messageWait
    JNE TellMessNext
    CMP DS:pcbSource, DX           ;     AND (pcb.source = pid) THEN DO;
    JNE TellMessNext

    MOV CX, exitCode
    MOV DS:pcbNote, CX             ;         return exitCode to waiting process

    LES BX, DWORD PTR DS:pcbPErrorOff
    MOV WORD PTR ES:[BX], eProcNotExist ;    error := eProcNotExist

    CMP AH, timedMessageWait       ;         IF curPcb.state = timedMessageWait THEN
    JNE TellMess10

    CALL DecTimedProcesses         ;             timedProcesses := timedProcesses - 1

TellMess10:
    MOV DS:pcbState, readyState    ;         curPCb.state := readyState

TellMessNext:
    MOV DS, DS:next                ;     curPid := curPcb.next
    JMP SHORT TellMessTopOfLoop

TellMessDone:
%IF (%PCAT) THEN
  (
    PUSH CS
    CALL PopFlags
  )
ELSE
  (
    POPF                        ; restore flags
  )
FI
    POP BP
    POP DS
    RET 4
TellMessageWaiters ENDP
PURGE pid, exitCode
$EJ

%IF (%AlwaysSave8087Regs EQ 1) THEN (

;    SwapTasksRoutine PROCEDURE
;
;    This is the actual code of the interrupt routine
;    This must be near and have no parameters

SwapTasksRoutine PROC NEAR
    PUSH BP
    MOV  BP, SP

    MOV  AX, osCurrentPid          ; assume DS = CS:DataFrame
    MOV  ES, AX                    ; ES := osCurrentPid
    MOV  CX, AX                    ; Save last pid in CX
    CMP  AX, goodBye
    JE   SwapTask10

    PUSH DS:WORD PTR curSlot       ; save current process' slot (rom/ems)

;;  TEST emsValid, TRUE
;;  JZ   SwapTask05

;;  PUSH ES
;;  LEA  AX, ES:pcbEms             ; save the current state of the EMS
;;  PUSH ES                        ; registers in the process control
;;  PUSH AX                        ; block before swapping tasks
;;  CALL EmsSaveContext
;;  POP  ES

SwapTask05:
    MOV  ES:pcbStackSeg, SS
    MOV  ES:pcbStackOff, SP        ; curPcb.stack = BUILDPTR(SS, SP)

    MOV  AL, ES:pcbUses8087
    RCR  AL, 1
    JNB  SwapTask10

    PUSH DS
    LDS  BX, ES:pcbP8087Regs
    FNSAVE DS:[BX]                 ; CALL SaveRealStatus(@pid8087.the8087regs)
    FWAIT
    POP  DS

SwapTask10:
    MOV  AX, nextPidToSchedule
    MOV  osCurrentPid, AX          ; osCurrentPid := nextpidToSchedule
    MOV  ES, AX                    ; ES = osCurrentPid

    MOV  SS, ES:pcbStackSeg        ; STACKBASE := curPcb.stackSeg
    MOV  SP, ES:pcbStackOff        ; STACKPTR := curPcb.stackOff

;;  TEST emsValid, TRUE
;;  JZ   SwapTask12

;;  PUSH ES
;;  LEA  AX, ES:pcbEms             ; restore the state of the EMS
;;  PUSH ES                        ; registers from this process control
;;  PUSH AX                        ; block
;;  CALL EmsSetActiveRam
;;  POP  ES

SwapTask12:
    MOV  AL, ES:pcbUses8087
    RCR  AL, 1                     ; IF curPcb.uses8087 THEN
    JNB  SwapTask20

    PUSH DS
    LDS  BX, ES:pcbP8087Regs
    FRSTOR DS:[BX]                 ; CALL RestoreRealStatus(@curPcb.the8087regs)
    FWAIT
    POP  DS

SwapTask20:
    POP  AX
    PUSH CX                        ; Save last pid
    CALL IntCpSetActiveRomSlot     ; slot to set passed in AL
    POP  CX                        ; Last pid

    TEST emsValid, TRUE
    JZ   SwapTaskExit

    MOV  DX, intMaskReg
    IN   AL, DX                    ; Get state of interrupt mask
    PUSH AX                        ; and save it
    MOV  AL, maskOffAllInts        ; Then mask off all interrupts
    OUT  DX, AL

    PUSH CX                        ; pid (last) to save ems state into
    PUSH ES                        ; pid (current) to restore ems state from
    CALL EmsSwapTasksEmsRam

    POP  AX
    MOV  DX, intMaskReg
    OUT  DX, AL                    ; Restore state of interrupt mask

SwapTaskExit:
    POP  BP
    RET
SwapTasksRoutine ENDP

) FI
$EJ

%IF (%AlwaysSave8087Regs EQ 0) THEN (

;    SwapTasksRoutine PROCEDURE
;
;    This is the actual code of the interrupt routine
;    This must be near and have no parameters

;    This variation is faster than the previous, but has some bug in it.
;    This can be seen by running Monty's Spin program in many windows
;    and swapping between those windows until one of them crashes.

SwapTasksRoutine PROC NEAR
    PUSH BP
    MOV  BP, SP

    MOV  AX, osCurrentPid          ; assume DS = CS:DataFrame
    MOV  ES, AX                    ; ES := osCurrentPid
    MOV  CX, AX                    ; Save last pid in CX
    CMP  AX, goodBye
    JE   SwapTask10

    PUSH DS:WORD PTR curSlot       ; save current process' slot (rom/ems)

    MOV  ES:pcbStackSeg, SS
    MOV  ES:pcbStackOff, SP        ; curPcb.stack = BUILDPTR(SS, SP)

SwapTask10:
    MOV  AX, nextPidToSchedule
    MOV  osCurrentPid, AX          ; osCurrentPid := nextpidToSchedule
    MOV  ES, AX                    ; ES = osCurrentPid

    MOV  SS, ES:pcbStackSeg        ; STACKBASE := curPcb.stackSeg
    MOV  SP, ES:pcbStackOff        ; STACKPTR := curPcb.stackOff

    MOV  AL, ES:pcbUses8087
    RCR  AL, 1                     ; IF curPcb.uses8087 THEN
    JNB  SwapTask20

; Additions 3/26/85 to optimize process switching

    MOV  AX, DS:pid8087            ;  IF (pid8087 <> osCurrentPid) AND 
    CMP  AX, NULLWORD              ;     (pid8087 <> NULLWORD) THEN
    JE   SwapTask15

    MOV  BX, ES
    CMP  AX, BX
    JE   SwapTask15

    PUSH DS
    MOV  DS, DS:pid8087
    LDS  BX, DS:pcbP8087Regs
    FNSAVE DS:[BX]                 ; CALL SaveRealStatus(@pid8087.the8087regs)
    FWAIT
    POP  DS

SwapTask15:
    MOV  BX, ES                    ;   IF pid8087 <> osCurrentPid THEN
    CMP  AX, BX
    JE   SwapTask17

    PUSH DS
    LDS  BX, ES:pcbP8087Regs
    FRSTOR DS:[BX]                 ; CALL RestoreRealStatus(@curPcb.the8087regs)
    FWAIT
    POP  DS

SwapTask17:
    MOV  pid8087, ES               ;   pid8087 = osCurrentPid

SwapTask20:
    POP  AX
    PUSH CX                        ; Save last pid
    CALL IntCpSetActiveRomSlot     ; slot to set passed in AL
    POP  CX                        ; Last pid

    TEST emsValid, TRUE
    JZ   SwapTaskExit

    MOV  DX, intMaskReg
    IN   AL, DX                    ; Get state of interrupt mask
    PUSH AX                        ; and save it
    MOV  AL, maskOffAllInts        ; Then mask off all interrupts
    OUT  DX, AL

    PUSH CX                        ; pid (last) to save ems state into
    PUSH ES                        ; pid (current) to restore ems state from
    CALL EmsSwapTasksEmsRam

    POP  AX
    MOV  DX, intMaskReg
    OUT  DX, AL                    ; Restore state of interrupt mask

SwapTaskExit:
    POP  BP
    RET
SwapTasksRoutine ENDP

) FI
$EJ

;    Reschedule : PROCEDURE (pid) CLEAN;
;
;    This will check for three things:
;
;    pid = roundRobin -> The next ready process in the current priority or lower
;          will be scheduled
;    pid = goodBye -> The current process is deleted, no state is saved.  The 
;          first ready process is scheduled.
;    pid = other -> That process will be tested for higher priority.  If not 
;          higher then no rescheduling occurs.

pid EQU WORD PTR [BP+8]

Reschedule PROC FAR
    PUSH DS
    MOV DS, CS:DataFrame
    PUSH BP
    MOV BP, SP

    CMP pid, roundRobin            ; IF pid = roundRobin THEN DO;
    JNE ReschTest2

    PUSH osCurrentPid              ;    osCurrentPid

    CALL RoundRobinProcess         ;    nextPidToSchedule := RoundRobinProcess(osCurrentPid)
    JMP SHORT ReschDoIt

ReschTest2:
    CMP pid, goodBye               ; ELSE IF pid = goodBye THEN DO;
    JNE ReschTest3

    MOV osCurrentPid, goodBye      ;     osCurrentPid := goodBye

    CALL FirstReadyProcess         ;     nextPidToSchedule := FirstReadyProcess
    JMP SHORT ReschDoIt

ReschTest3:
    MOV ES, pid
    MOV AL, ES:pcbPriority
    MOV ES, osCurrentPid           ; ELSE IF pcb.priority <= curPcb.priority THEN 
    CMP AL, ES:pcbPriority
    JA ReschDone

    MOV AX, pid

ReschDoIt:                         ; AX = nextPidToSchedule
    CMP AX, osCurrentPid           ; IF nextPidToSchedule = osCurrentPid THEN
    JE ReschDone                   ;     RETURN

    MOV nextPidToSchedule, AX      ; nextPidToSchedule := AX
    CALL SwapTasksRoutine          ; do the rescheduling

ReschDone:
    POP BP
    POP DS
    RET 2
Reschedule ENDP
PURGE pid
$EJ
;    CpSignal : PROCEDURE (sid, mode, note, pError) CLEAN
;        DCL sid SidType;
;        DCL mode BYTE;
;        DCL note WORD;
;        DCL pError PTR;
;
;    This will signal a semaphore.  If a process is waiting on it, then it will
;    be put into the ready state and given a 1 word note, and the semaphore stays
;    in the busy state.  If there are no processes waiting, then the sema is left
;    not busy and the next process to wait gets the signal.  Rescheduling will occur
;    only if a process is already waiting.

pError EQU DWORD PTR [BP+8]        ; fourth param
note EQU WORD PTR [BP+12]          ; third param
mode EQU BYTE PTR [BP+14]          ; second param
sid EQU WORD PTR [BP+16]           ; first param

CpSignal PROC FAR
    PUSH DS
    PUSH BP
    MOV BP, SP
    PUSHF

    CLI                            ; disable interrupts

    LDS BX, pError
    MOV WORD PTR DS:[BX], eOK      ; error := eOK

    PUSH sid
    CALL SemaphoreExists           ; IF SemaphoreExists(sid) THEN DO;
    RCR AL,1
    JNB OsSignalNotExist

OsSignalExists:
    PUSH sid
    CALL FirstWaitingProcess       ;     AX (pid) := FirstWaitingProcess
    CMP AX, nullWord               ;     IF pid = nullWord THEN DO;
    JNE OsSignalYes

    MOV AL, mode
    AND AL, snoozeSignalMask       ;         AL = mode AND snoozeSignalMask
    CMP AL, signalNormal           ;         IF mode = signalNormal THEN DO;
    JNE OsSignalDone

    MOV DS, sid
    MOV AX, note
    MOV DS:scbNote, AX             ;             scb.note := note

    MOV DS:scbBusy, signalled      ;             scb.signalled := signalled
    JMP SHORT OsSignalDone

OsSignalYes:                       ;     ELSE (AX = pid); let DS be pid
    MOV ES, sid                    ;         let ES = sid
    MOV DS, AX                     ;         DS := AX (pid)

    MOV SI, DS                     ;         firstPid := pid; let SI be firstPid

    MOV ES:scbBusy, DS             ;         scb.busy := pid

OsSignalTopOfLoop:
    MOV AX, DS                     ;         DO WHILE pid <> nullWord
    CMP AX, nullWord
    JE OsSignalReschedule

    MOV AX, note
    MOV DS:pcbNote, AX             ;             pcb.note := note

    CMP DS:pcbState, timedSemaphoreWait
    JNE OsSignal10                 ;             IF pcb.state = timedSemaphoreWait THEN

    CALL DecTimedProcesses         ;                 timedProcesses := timedProcesses - 1;

OsSignal10:
    MOV DS:pcbState, readyState    ;             pcb.state := readyState;

    DEC ES:scbCount                ;             scb.count := scb.count - 1

    MOV AL, mode
    AND AL, snoozeSignalMask       ;             AL = mode AND snoozeSignalMask
    CMP AL, signalNormal           ;             IF mode = normalSignal THEN GOTO DoReschedule
    JE OsSignalReschedule

PUSH SI
PUSH ES                            ;             save sid
    PUSH ES                        ;             push sid

    CALL FirstWaitingProcess
POP ES
POP SI                             ;             restore these
    MOV DS, AX                     ;             pid := FirstWaitingProcess(sid)
    JMP SHORT OsSignalTopOfLoop

OsSignalNotExist:
    LDS BX, pError                 ; ELSE error := eSemaNotExist
    MOV WORD PTR DS:[BX], eSemaNotExist
    JMP SHORT OsSignalDone

OsSignalReschedule:
    CMP mode, snoozeSignalMask     ;         IF (mode < snoozeSignalMask) THEN DO;
    JAE OsSignalDont

    PUSH SI
    CALL Reschedule                ;             Reschedule(firstPid)
    JMP SHORT OsSignalDone

OsSignalDont:                      ;         ELSE DO;
;    MOV DS, CS:DataFrame
;    MOV DS:needToReschedule, TRUE  ;             needToReschedule := TRUE

OsSignalDone:
%IF (%PCAT) THEN
  (
    PUSH CS
    CALL PopFlags
  )
ELSE
  (
    POPF                        ; restore flags
  )
FI
    POP BP
    POP DS
    RET 10
CpSignal ENDP
PURGE pError, note, mode, sid
$EJ
;    CpWait : PROCEDURE (sid, timeLimit, pError) WORD CLEAN
;        DCL sid SidType;
;        DCL timeLimit WORD;
;        DCL pError PTR;
;
;    This will wait for a signal on a semaphore for a certain amount
;    of time.  If the semaphore is not busy, then the process can
;    continue right away.  If it is busy, then the process must wait.
;    Note: processes of equal priority will wait in their order on the
;    the process q, not in the order of their waits.

pError EQU DWORD PTR [BP+8]        ; third param
timeLimit EQU WORD PTR [BP+12]     ; second param
sid EQU WORD PTR [BP+14]           ; first param

CpWait PROC FAR
    PUSH DS
    PUSH BP
    MOV BP, SP
    PUSHF

    CLI                            ; DISABLE

    LDS BX, pError
    MOV WORD PTR DS:[BX], eOK      ; error := eOK

    PUSH sid
    CALL SemaphoreExists
    RCR AL, 1                      ; IF SemaphoreExists(sid) THEN DO;
    JNB OsWaitNotExist

OsWaitExists:
    MOV DS, sid
    CMP DS:scbBusy, signalled      ;     IF scb.busy THEN DO;
    JNE OsWaitNotSignalled

    CALL CpWhoAmI
    MOV ES:scbBusy, AX             ;         scb.busy := osCurrentPid

    MOV AX, DS:scbNote             ;         RETURN (scb.note)
    JMP SHORT OsWaitDone

OsWaitNotSignalled:                ;     ELSE
    CMP timeLimit, 0               ;         IF timeLimit = 0 THEN DO;
    JNE OsWait10

    LDS BX, pError
    MOV WORD PTR DS:[BX], eTimeOut ;             error := eTimeOut

    XOR AX, AX                     ;             RETURN (0);
    JMP SHORT OsWaitDone

OsWait10:
    CALL CpWhoAmI
    MOV DS, AX                     ;         LET ds ^ current pcb

    MOV DS:pcbState, semaphoreWait ;         curPcb.state = semaphoreWait

    CMP timeLimit, nullWord        ;         IF timeLimit <> nullWord
    JE OsWaitForever

    MOV DS:pcbState, timedSemaphoreWait ;        curPcb.state = timedSemaphoreWait

    CALL IncTimedProcesses         ;             timedProcesses = timedProcesses + 1

    PUSH timeLimit
    CALL ComputeTime
    MOV DS:pcbTimeLimit, AX        ;         curPcb.timeLimit = ComputeTime(timeLimit)

OsWaitForever:
    LES BX, pError
    MOV DS:pcbPErrorSeg, ES        ;         curPcb.pError = pError
    MOV DS:pcbPErrorOff, BX

    MOV AX, sid
    MOV DS:pcbSource, AX           ;         curPcb.source = sid

    MOV ES, sid
    INC ES:scbCount                ;         scb.count = scb.count + 1

    MOV AX, roundRobin
    PUSH AX                        ;         roundRobin

    CALL Reschedule                ;         Reschedule

    MOV AX, DS:pcbNote             ;         RETURN (curPcb.note)
    JMP SHORT OsWaitDone

OsWaitNotExist:                    ; ELSE
    LDS BX, pError
    MOV WORD PTR DS:[BX], eSemaNotExist ;error = eSemaNotExist

    XOR AX, AX                     ;     RETURN (0)

OsWaitDone:
%IF (%PCAT) THEN
  (
    PUSH CS
    CALL PopFlags
  )
ELSE
  (
    POPF                        ; restore flags
  )
FI
    POP BP
    POP DS
    RET 8
CpWait ENDP
PURGE sid, timeLimit, pError
$EJ

;    CpSend: PROCEDURE (sourceProcID, destPid, messageType, 
;                       note, pMessage, pError)
;
;    This will send a message from one process to another.  If the process is
;    already waiting for a message from this process (or anyone) then it will
;    be procesed and rescheduling will occur.  Otherwise the message will be 
;    placed into the message queue of the receiving process.  The message 
;    types must also match up.

pError EQU DWORD PTR [BP+8]        ; sixth param
pMessage EQU DWORD PTR [BP+12]     ; fifth param
note EQU WORD PTR [BP+16]          ; fourth param
messageType EQU WORD PTR [BP+18]   ; third param
destPid EQU WORD PTR [BP+20]       ; second param
sourceProcID EQU WORD PTR [BP+22]  ; first param

; let DS be destPid

CpSend PROC FAR
    PUSH DS
    PUSH BP
    MOV BP, SP
    PUSHF

    CLI                            ; DISABLE

    LDS BX, pError
    MOV WORD PTR DS:[BX], eOK      ; error := eOK

    XOR  CX, CX                    ; MemBlkAddr := 0

CpSendCheckFit:
    MOV DS, destPid                ; DS := destPid

    MOV AL, DS:pcbState
    AND AL, timedMask
    CMP AL, messageWait            ;     IF ((destPcb.state AND timedMask) = 
                                   ;          messageWait) AND
    JNE CpSendNotAFit

    MOV  AX, sourceProcID
    CMP  AX, DS:pcbSource          ;       ((destPcb.source = osCurrentPid) OR
    JE   CpSendCheckFit2
    CMP  DS:pcbSource, NULLWORD
    JNE  CpSendNotAFit             ;        (destPcb.source = nullWord)) AND

CpSendCheckFit2:
    MOV  AX, DS:pcbMessageType
    CMP  AX, NULLWORD              ;       ((destPcb.messageType = nullWord) OR
    JE   CpSendFound
    CMP  AX, messageType           ;        (destPcb.messageType = 
                                   ;         messageType)) THEN DO;
    JE   CpSendFound

CpSendNotAFit:                     ;     ELSE
    OR   CX, CX
    JNZ  CpSendMsgBlkAlloc         ;       IF memory block not allocated

    PUSH DS                        ;         destPid

    MOV  AX, SIZE mcbType
    PUSH AX                        ;         SIZE (mcb)

    LES  BX, pError
    PUSH ES                        ;         @error
    PUSH BX

    STI                            ;         ENABLE
    CALL IntAllocate               ;         what if process is deleted here ???
    CLI                            ;         DISABLE

    MOV  AX, ES                    ;         save selector in CX
    MOV  CX, AX
    LES  BX, pError
    CMP  WORD PTR ES:[BX], eOK
    JNE  CpSendDone                ;         IF error = eOK THEN DO;
    JMP  SHORT CpSendCheckFit

CpSendMsgBlkAlloc:
    MOV  DX, DS                    ;             save destPid

    MOV  AX, CX
    MOV  DS, AX                    ;             let DS = mid

    MOV  AX, note
    MOV  DS:mcbNote, AX            ;             mcb.note := note

    MOV  AX, messageType
    MOV  DS:mcbMessageType, AX     ;            mcb.messageType = messageType

    LES  BX, pMessage
    MOV  DS:mcbPMessageOff, BX     ;            mcb.pMessage := pMessage
    MOV  DS:mcbPMessageSeg, ES

    MOV  AX, sourceProcID
    MOV  DS:mcbSourcePid, AX       ;             mcb.sourcePid := sourceProcID

    PUSH DX
    MOV  BX, pcbHeadOfQOffset      ;             @destPcb.headOfQ
    PUSH BX

    MOV  ES, DX
    PUSH ES:pcbTailOfQ             ;             add to end of message queue

    PUSH DS                        ;             push mid

    CALL OsInsertIntoQ
    JMP  SHORT CpSendDone

CpSendFound:
    MOV  AX, note
    MOV  DS:pcbNote, AX            ;         destPcb.note = note

    LES  BX, pMessage
    MOV  DS:pcbPMessageSeg, ES
    MOV  DS:pcbPMessageOff, BX     ;         destPcb.pMessage = pMessage

    CMP  DS:pcbState, timedMessageWait
    JNE  CpSendNotTimedMessage     ;         IF destPcb.state = 
                                   ;            timedMessageWait THEN

    CALL DecTimedProcesses         ;         timedProcesses = timedProcesses - 1

CpSendNotTimedMessage:
    MOV  DS:pcbState, readyState   ;         destPcb.state = readyState

    PUSH CX                        ;         save message block address

    PUSH DS                        ;         destPid
    CALL Reschedule                ;         Reschedule

    POP  CX                        ;         restore message block address

    OR   CX, CX
    JZ   CpSendDone                ;         IF message block is allocated

    PUSH CX                        ;             @mid
    CALL FreeMe                    ;             free the message blk

CpSendDone:
%IF (%PCAT) THEN
  (
    PUSH CS
    CALL PopFlags
  )
ELSE
  (
    POPF                        ; restore flags
  )
FI
    POP  BP
    POP  DS
    RET  16
CpSend ENDP
PURGE sourceProcId, pMessage, note, messageType, destPid, pError
$EJ

;    CpReceive: PROCEDURE(sourcePid, messageType, timeLimit, pNote, pError) PTR;
;
;    This will allow a process to receive a message from another process.  The message must
;    be sent with this pid and the proper type.  TimerLimit allows a process to wait any amount
;    even zero

pError EQU DWORD PTR [BP+8]        ; fifth param
pNote EQU DWORD PTR [BP+12]        ; fourth param
timeLimit EQU WORD PTR [BP+16]     ; third param
messageType EQU WORD PTR [BP+18]   ; second param
sourcePid EQU WORD PTR [BP+20]     ; first param

CpReceive PROC FAR
    PUSH DS
    PUSH BP
    MOV BP, SP
    PUSHF

    CLI                            ; DISABLE

    LDS BX, pError
    MOV WORD PTR DS:[BX], eOK      ; error := eOK

    CMP sourcePid, nullWord
    JE OsRec10                     ; IF sourcePid <> nullWord THEN DO;

    PUSH sourcePid                 ;    sourcePid

    CALL ProcessExists
    RCR AL, 1                      ;    IF NOT(ProcessExists(sourcePid) THEN DO;
    JB OsRec10

; These next lines have been commented out
; which means you can receive from anyone

    LDS BX, pError
    MOV WORD PTR DS:[BX], eProcNotExist ;   error := eOK
    JMP OsRecRetNull

OsRec10:
    PUSH sourcePid                ; sourcePid

    PUSH messageType              ; messageType

    CALL AnyMessage
    CMP AX, nullWord              ; IF mid (AX) <> nullWord THEN DO;
    JE OsRecNoMessage

    MOV DS, AX                    ;     let DS = mid

    MOV AX, DS:mcbNote
    LES BX, pNote                 ;     note = mcb.note
    MOV ES:[BX], AX

    MOV ES, DS:mcbPMessageSeg
    MOV BX, DS:mcbPMessageOff     ;     ES:BX := pMessage

PUSH ES
PUSH BX                           ;     save these

    CALL CpWhoAmI
    PUSH AX
    MOV AX, pcbHeadOfQOffset      ;    @curPcb.headOfQ
    PUSH AX

    PUSH DS                       ;    mid

    CALL OsRemoveFromQ

    PUSH DS                       ;    @mid

    CALL FreeMe
POP BX
POP ES                            ;    restore these

    JMP SHORT OsRecDone

OsRecNoMessage:                   ; ELSE
    CMP timeLimit, 0
    JNE OsRecTime                 ;     IF timeLimit = 0 THEN DO

    LDS BX, pError
    MOV WORD PTR DS:[BX], eTimeOut ;         error = eTimeOut

OsRecRetNull:

    MOV AX, nullWord
    MOV ES, AX
    MOV BX, 0000fh                ;         RETURN (nullPtr)

    JMP SHORT OsRecDone

OsRecTime:                        ;     ELSE DO
    CALL CpWhoAmI
    MOV DS, AX                    ;         let DS = curPcb

    MOV DS:pcbState, messageWait  ;         curPcb.state = messageWait

    CMP timeLimit, nullWord
    JE OsRecForever               ;         IF timeLimit <> nullWord THEN DO;

    MOV DS:pcbState, timedMessageWait ;        curPcb.state := timedMessageWait

    PUSH timeLimit                ;             timeLimit

    CALL ComputeTime
    MOV DS:pcbTimeLimit, AX       ;             curPcb.timeLimit := ComputeTime(timeLimit)

    CALL IncTimedProcesses        ;             timedProcesses := timedProcesses + 1

OsRecForever:
    MOV AX, sourcePid
    MOV DS:pcbSource, AX          ;         curPcb.source := sourcePid

    MOV AX, messageType
    MOV DS:pcbMessageType, AX     ;         curPcb.messageType := messageType


    LES BX, pError
    MOV DS:pcbPErrorSeg, ES       ;         curPcb.pError := pError
    MOV DS:pcbPErrorOff, BX

    MOV AX, roundRobin            ;         roundRobin

    PUSH AX
    CALL Reschedule

    MOV AX, DS:pcbNote
    LES BX, pNote
    MOV ES:[BX], AX               ;         note := curPcb.note

    MOV ES, DS:pcbPMessageSEG
    MOV BX, DS:pcbPMessageOFF     ;         RETURN (curPcb.pMessage)

OsRecDone:
%IF (%PCAT) THEN
  (
    PUSH CS
    CALL PopFlags
  )
ELSE
  (
    POPF                        ; restore flags
  )
FI
    POP BP
    POP DS
    RET 14
CpReceive ENDP
PURGE pError, pNote, timeLimit, messageType, sourcePid
$EJ
;    CpCreateProcess : PROCEDURE (pid)
;        DCL pid PidType
;
;    This will add a pcb to the ready q.  It will initialize as
;    many fields as it can.

pid EQU WORD PTR [BP+8]

; let DS be pid

CpCreateProcess PROC FAR
    PUSH DS
    PUSH BP
    MOV BP, SP
    PUSHF

    CLI                            ; DISABLE

    MOV DS, pid                    ; DS := pid

    MOV DS:pcbIdCode, processIdCode ; pcb.idCode := processIdCode

    PUSH DS
    MOV AX, pcbHeadOfQOffset       ; @pcb.headOfQ
    PUSH AX

    MOV AL, FALSE                  ; FALSE
    PUSH AX

    MOV AX, SIZE mcbType           ; SIZE(mcb)
    PUSH AX

    CALL OsInitQcb

; *** Hornet Change to init 8087 area ... 12/8/84

    MOV  AL, DS:pcbUses8087        ; IF pcb.uses8087 THEN
    RCR  AL, 1
    JNB  CpCreate10
    PUSH DS
    LDS  BX, DS:pcbP8087Regs       
    FNSAVE DS:[BX]                 ;   CALL SaveRealStatus (pcb.p8087Regs)
    FWAIT
    POP  DS
CpCreate10:

; *** End Hornet change

    PUSH DS
    POP ES
    LEA DI, DS:pcbHeap             ; ES:DI := @pcb.heap
    MOV CX, 16                     ; SIZE of heap
    MOV AL, 0
    CLD
    REP STOSB                      ; CALL SETB(0, @pcb.heap, SIZE(pcb.heap))

    MOV DS:pcbState, readyState    ; pcb.state = readyState

    LES BX, DWORD PTR DS:pcbStackOff
   
    MOV AX, OFFSET PopStart
    MOV ES:[BX].regKip, AX         ; regTable.kip = OFFSET(@PopStart)

    MOV ES:[BX].regFl, initialFlagState ; regTable.fl = initialFlagState

; *** Split board change

    MOV CX, ES:[BX].regSlot        ; save slot

    SUB DS:pcbStackOff, 2          ; make room on stack for initial slot

    SUB BX, 2                      ; make ES:[BX] ^ 2 before original reg table

    MOV ES:[BX], CX                ; put slot on top of reg table

; *** end of change

; *** Added for EMS initialization 6/10/87

    PUSH DS                        ; process to init ems values to
    PUSH CX                        ; ems slot to use for initialization
    CALL EmsSetProcessRam

; *** End of change

    PUSH DS
    CALL AddToReadyQ               ; Add this to OsProcessQ

%IF (%PCAT) THEN
  (
    PUSH CS
    CALL PopFlags
  )
ELSE
  (
    POPF                        ; restore flags
  )
FI
    POP BP
    POP DS
    RET 2
CpCreateProcess ENDP
PURGE pid
$EJ
;    CpDeleteProcess : PROCEDURE (pid, exitCode, pError) CLEAN
;        DCL pid PidType;
;        DCL pError PTR;
;
;    This will delete the given process.  This will tell any processes
;    waiting on messages from it.  It will also free up the pcb.  Rescheduling
;    will occur only if this process is deleting itself.

pError EQU DWORD PTR [BP+8]        ; second param
exitCode EQU WORD PTR [BP+12]          ; code from OsExit
pid EQU WORD PTR [BP+14]           ; first param

hariKari EQU BYTE PTR [BP-2]       ; 1 local

CpDeleteProcess PROC FAR
    PUSH DS
    MOV DS, CS:DataFrame
    PUSH BP
    MOV BP, SP
    SUB SP, 2                      ; 1 local
    PUSHF

    CLI                            ; DISABLE
   
; Added to optimize process switches 3/26/85
    MOV AX, pid
    CMP AX, pid8087
    JNE CpDelete5
    MOV pid8087, NULLWORD
CpDelete5:
; End of addition

    MOV AX, osCurrentPid
    CMP AX, pid
    MOV AL, TRUE                   ; hariKari = (pid = osCurrentPid)
    JE CpDelete10

    MOV AL, FALSE

CpDelete10:
    MOV hariKari, AL

    PUSH pid                       ; pid

    CALL ProcessExists
    RCR AL, 1                      ; IF ProcessExists(pid) THEN DO;
    JNB CpDeleteNotExist

    MOV DS, pid                    ;     let DS be pid

    MOV AL, DS:pcbState
    TEST AL, timedWait
    JZ CpDelete20                  ;     IF (pcb.state AND timedWait) <> 0 THEN 

    PUSH AX
    CALL DecTimedProcesses         ;         timedProcesses := timedProcesses - 1;
    POP AX

CpDelete20:
    AND AL, timedMask
    CMP AL, semaphoreWait          ;     IF (pcb.state AND timedMask) = semaphoreWait THEN
    JNE CpDelete30

    MOV ES, DS:pcbSource
    CMP ES:scbIdCode, semaphoreIdCode ;         IF scb.idCode = semaphoreIdCode THEN
    JNE CpDelete30

    DEC ES:scbCount                ;                scb.count = scb.count - 1;

CpDelete30:
    PUSH DS                        ;    pid

    PUSH exitCode                  ;    code

    CALL TellMessageWaiters

    INC DS:pcbIdCode               ;    pcb.idCode := NOT(pcb.idCode)

    PUSH DS                        ;    @pcb

    CALL FreeMe

    PUSH CS:DataFrame
    MOV AX, OFFSET OsProcessQ      ;     @OsProcessQ
    PUSH AX

    PUSH pid                       ;     pid

    CALL OsRemoveFromQ

    CMP hariKari, TRUE
    JNE CpDelete40                 ;    IF hariKari THEN

    MOV AX, goodBye
    PUSH AX                        ;        goodbye

    CALL Reschedule

CpDelete40:
    LDS BX, pError
    MOV WORD PTR DS:[BX], eOK      ;     error = eOK

    JMP SHORT CpDeleteDone

CpDeleteNotExist:
    LDS BX, pError
    MOV WORD PTR DS:[BX], eProcNotExist ;     error = eProcNotExist

CpDeleteDone:

%IF (%PCAT) THEN
  (
    PUSH CS
    CALL PopFlags
  )
ELSE
  (
    POPF                        ; restore flags
  )
FI
    MOV SP, BP
    POP BP
    POP DS
    RET 8
CpDeleteProcess ENDP
PURGE pError, pid, hariKari, exitCode
$EJ
;    CpDelay : PROCEDURE (timeLimit) CLEAN
;        DCL timeLimit WORD;
;
;    This will delay the current process for timeLimit milleseconds.
;    Even if timeLimit is 0, rescheduling will occur.

timeLimit EQU WORD PTR [BP+8]

; let DS be osCurrentPid

CpDelay PROC FAR
    PUSH DS
    PUSH BP
    MOV BP, SP
    PUSHF

    CLI                            ; DISABLE

    CMP timeLimit, 0
    JE OsDelayReschedule           ; IF timeLimit <> 0 THEN DO;

    CALL CpWhoAmI
    MOV DS, AX                     ;     DS := osCurrentPid

    PUSH timeLimit
    CALL ComputeTime               ;     curPcb.timeLimit := ComputeTime(timeLImit)
    MOV DS:pcbTimeLimit, AX

    MOV DS:pcbState, timedWait     ;     curPcb.state := timedWait

    MOV AX, CS:DataFrame
    MOV DS:pcbPErrorSeg, AX
    MOV AX, OFFSET dummyError      ;     curPcb.pError := @dummyError
    MOV DS:pcbPErrorOff, AX

    CALL IncTimedProcesses         ;     timedProcesses = timedProcesses + 1

OsDelayReschedule:
    MOV AX, roundRobin
    PUSH AX                        ; roundRobin

    CALL Reschedule

%IF (%PCAT) THEN
  (
    PUSH CS
    CALL PopFlags
  )
ELSE
  (
    POPF                        ; restore flags
  )
FI
    POP BP
    POP DS
    RET 2
CpDelay ENDP
PURGE timeLimit
$EJ
;    CpSetPriority : PROCEDURE (pid, priority, pError) CLEAN;
;        DCL pid PidType;
;        DCL priority BYTE;
;        DCL pError PTR;
;
;    This will set the priority of the given process.
;    IF the process is ready, then rescheduling will occur.

pError EQU DWORD PTR [BP+8]        ; third param
priority EQU BYTE PTR [BP+12]      ; second param
pid EQU WORD PTR [BP+14]           ; first param

; let DS = pid

CpSetPriority PROC FAR
    PUSH DS
    PUSH BP
    MOV BP, SP
    PUSHF

    CLI                            ; DISABLE

    LDS BX, pError
    MOV WORD PTR DS:[BX], eOK      ; error = eOK

    MOV DS, pid                    ; DS := pid

    PUSH DS
    CALL ProcessExists
    RCR AL, 1                      ; IF ProcessExists(pid) THEN DO;
    JNB OsSetNotExist

    PUSH CS:DataFrame
    MOV AX, OFFSET OsProcessQ      ;     @OsProcessQ
    PUSH AX

    PUSH DS                        ;     pid

    CALL OsRemoveFromQ

    MOV AL, priority
    MOV DS:pcbPriority, AL         ;     pcb.priority := priority

    PUSH DS                        ;     pid

    CALL AddToReadyQ

    CALL FirstReadyProcess         ;     push first ready process
    PUSH AX

    CALL Reschedule

    JMP SHORT OsSetDone

OsSetNotExist:
    LDS BX, pError
    MOV WORD PTR DS:[BX], eProcNotExist ; error = eOK

OsSetDone:
%IF (%PCAT) THEN
  (
    PUSH CS
    CALL PopFlags
  )
ELSE
  (
    POPF                        ; restore flags
  )
FI
    POP BP
    POP DS
    RET 8
CpSetPriority ENDP
PURGE pError, priority, pid
$EJ
;    CpCreateSemaphore : PROCEDURE (sid) CLEAN;
;        DCL sid SidType
;
;    This will add a semaphore to the semaphore queue
;    and initialize its fields

sid EQU WORD PTR [BP+8]

; let DS be sid

CpCreateSemaphore PROC FAR
    PUSH DS
    PUSH BP
    MOV BP, SP
    PUSHF

    CLI                            ; DISABLE

    MOV DS, sid                    ; DS = sid

    CALL CpWhoAmI
    MOV DS:scbParentPid, AX        ; scb.parentPid = osCurrentPid

    XOR AX, AX
    MOV DS:scbBusy, AX             ; scb.busy = notSignalled

    MOV DS:scbNote, AX             ; scb.note = 0

    MOV DS:scbCount, AX            ; scb.count = 0

    MOV DS:scbIdCode, semaphoreIdCode

    PUSH CS:DataFrame
    MOV AX, OFFSET OsSemaQ         ; @OsSemaQ
    PUSH AX

    MOV AX, nullWord               ; add to front of q
    PUSH AX

    PUSH DS                        ; sid

    CALL OsInsertIntoQ

%IF (%PCAT) THEN
  (
    PUSH CS
    CALL PopFlags
  )
ELSE
  (
    POPF                        ; restore flags
  )
FI
    POP BP
    POP DS
    RET 2
CpCreateSemaphore ENDP
PURGE sid
$EJ
;    CpDeleteSemaphore : PROCEDURE (sid, pError) CLEAN
;        DCL sid SidType;
;        DCL pError PTR;
;
;    This will delete a semaphore.  Any processes waiting on the
;    semaphore will get a Semaphore not exist error.

pError EQU DWORD PTR [BP+8]        ; second param
sid EQU WORD PTR [BP+12]

; let DS be sid

CpDeleteSemaphore PROC FAR         
    PUSH DS
    PUSH BP
    MOV BP, SP
    PUSHF

    CLI                            ; DISABLE

    LDS BX, pError
    MOV WORD PTR DS:[BX], eOK      ; error = eOK

    MOV DS, sid                    ; DS = sid

    PUSH DS
    CALL SemaphoreExists           ; IF SemaphoreExists(sid) THEN DO;
    RCR AL, 1
    JNB OsDSNotExist

    PUSH DS                        ;     sid

    CALL TellWaiters

    PUSH CS:DataFrame
    MOV AX, OFFSET OsSemaQ         ;     @OsSemaQ
    PUSH AX

    PUSH DS                        ;     sid

    CALL OsRemoveFromQ

    INC DS:scbIdCode               ;     scb.idCode = NOT(scb.idCode)

    PUSH DS                        ;     @scb

    CALL FreeMe

    CALL FirstReadyProcess
    PUSH AX                        ;     push first ready process

    CALL Reschedule

    JMP SHORT OsDsDone

OsDsNotExist:
    LDS BX, pError
    MOV WORD PTR DS:[BX], eSemaNotExist ; error = eSemaNotExist

OsDsDone:
%IF (%PCAT) THEN
  (
    PUSH CS
    CALL PopFlags
  )
ELSE
  (
    POPF                        ; restore flags
  )
FI
    POP BP
    POP DS
    RET 6
CpDeleteSemaphore ENDP
PURGE sid, pError
$EJ
;    TimerInterrupt : PROCEDURE CLEAN
;
;    This is called for each tick of the clock.  It will
;    go through the process q and decrement the time left of
;    any processes waiting on time.  If the time left goes to zero,
;    then the process is put into the ready state with a timeout
;    error, and rescheduling will occur.

; let DS be pid
; let CX be count
; let SI be numTimedProcesses
; let DI be firstReadyPid

TimerInterrupt PROC FAR
    PUSH DS
    PUSH BP
    MOV BP, SP

    MOV DS, CS:DataFrame
    MOV SI, DS:timedProcesses       ; numTimedProcesses = timedProcesses

    MOV DI, nullWord                ; firstReadyPid = nullWord

    CALL HeadOfProcessQ             ; DS = OsProcessQ.headOfQ

    XOR CX, CX                      ; count = 0

    MOV AX, DS                      ; init AX
TimerTopOfLoop:
    MOV DS, AX
    CMP AX, nullWord                ; DO WHILE (pid <> nullWord)
    JE TimerDone
    CMP CX, SI                      ;     AND (count < numTimedProcesses);
    JAE TimerDone

    MOV AL, DS:pcbState
    MOV BL, AL
    CMP AL, timedWait               ;     IF pcb.state >= timedWait THEN DO;
    JB TimerNext

    MOV AX, DS:pcbTimeLimit
    CMP AX, 0                       ;         IF pcb.timeLimit = 0 THEN DO;
    JE TimerIsZero

TimerNotZero:                       ;         ELSE DO;
    DEC AX
    MOV DS:pcbTimeLimit, AX         ;             pcb.timeLimit := pcb.timeLimit - 1

TimerIncCount:
    INC CX                          ;         count := count + 1

TimerNext:
    MOV AX, DS:next                 ;     pid := pcb.next
    JMP TimerTopOfLoop

TimerIsZero:
    CMP BL, timedSemaphoreWait      ;             IF pcb.state = timedSemaphoreWait THEN DO;
    JNE TimerNotSema

    MOV ES, DS:pcbSource
    DEC ES:scbCount                 ;                 scb.count = scb.count - 1

TimerNotSema:
    MOV DS:pcbState, readyState     ;             pcb.state := readyState

    LES BX, DWORD PTR DS:pcbPErrorOff
    MOV WORD PTR ES:[BX], eTimeOut  ;             error := eTimeOut

    CALL DecTimedProcesses          ;             timedProcesses -= 1

    CMP DI, nullWord                ;             IF firstReadyPid = nullWord THEN
    JNE TimerIncCount

    MOV  DI, DS                     ;                firstReadyPid := pid
    JMP SHORT TimerIncCount

TimerDone:
;    MOV DS, CS:DataFrame
;    CMP DS:needToReschedule, TRUE   ; IF needToReschedule THEN DO;
;    JNE TimerDoIt

;    MOV DS:needToReschedule, FALSE
;    CALL FirstReadyProcess          ;      use first ready process
;    MOV DI, AX

TimerDoIt:
    CMP DI, nullWord                ; IF firstReadyPid <> nullWord THEN 
    JE TimerReturn

    PUSH DI                         ; firstReadyPid

    CALL Reschedule

TimerReturn:
    POP BP
    POP DS
    RET
TimerInterrupt ENDP


;    LoopProc
;
;    This will just loop forever

LoopProc PROC FAR

LoopLoop:
    STI                     ; enable Interrupts
    JMP  LoopLoop           ; loop again

LoopProc ENDP
$EJ

;    InitMultiTasking : PROCEDURE (pRoutine) CLEAN;
;      DCL pRoutine  PTR;
;
;    This will init all the multitasking junk

pRoutineSeg  EQU [BP+6]
pRoutineOff  EQU [BP+4]

minStkSize   EQU 256

InitMultiTasking PROC FAR
;   PUSH DS
;   PUSH BP
    MOV  DS, CS:DataFrame
    MOV  BP, SP

    MOV  pid8087, NULLWORD          ; added 3/26/85 to optimize process switches

    PUSH DS
    MOV  AX, OFFSET osProcessQ      ; @osProcessQ
    PUSH AX
    MOV  AL, FALSE                  ; FALSE
    PUSH AX
    MOV  AX, SIZE PcbType - dfltCntxtSize
    ADD  AX, emsContextSize         ; SIZE (PcbType) + emsContextSize
    PUSH AX
    CALL OsInitQcb

    PUSH DS
    MOV  AX, OFFSET osSemaQ         ; @osSemaQ
    PUSH AX
    MOV  AL, FALSE                  ; FALSE
    PUSH AX
    MOV  AX, SIZE ScbType           ; size of a scb
    PUSH AX
    CALL OsInitQcb

    CALL InitMemMgr                 ; initialize memory manager

;   MOV  needToReschedule, FALSE    ; needToReschedule := FALSE

; Create busy process

; Since the busy stack is the one that is going to "hang" around forever,
; allocate its pcb and use InteGRiD's stack.  The temporary process
; below will have both its stack and its pcb allocated (and later freed)

    XOR  AX, AX                     ; system pid
    PUSH AX
    MOV  AX, SIZE PcbType - dfltCntxtSize
    ADD  AX, emsContextSize
    PUSH AX
    MOV  AX, OFFSET dummyError
    PUSH DS
    PUSH AX
    CALL IntAllocate                ; Returns ES:BX => pcb

    MOV  osCurrentPid, ES           ; osCurrentPid := IntAllocate (SIZE(pcb))

    MOV  DI, BX
    MOV  CX, SIZE PcbType - dfltCntxtSize
    MOV  AL, 0
    CLD                             ; set pcb to zero (except ems context)
    REP  STOSB                      ; ems context part is set in CpCreateProcess

; I'm using the top portion of InteGRiD's stack for the busy process' regtable
; and the stack area below that is used for the code below as well as 
; eventually becoming the stack of the busy process (After calling reschedule)
; Two extra bytes are being subtracted from the stack because this is where
; the curSlot will be put in CpCreateProcess and since the current stack and
; the busy process' future stack are the same, then the curSlot value would
; have been overwritten.

    MOV  BX, SP
    SUB  BX, SIZE RegTableType      ; Put busy's regtable at top of the stack
    MOV  SP, BX
    DEC  SP
    DEC  SP                         ; Leave room for curSlot change (See above)

    MOV  AX, pRoutineSeg
    MOV  SS:[BX].regCs, AX          ; regTable.cs = SELECTOR (pRoutine)

    MOV  AX, pRoutineOff
    MOV  SS:[BX].regIp, AX          ; regTable.ip = OFFSETOF (pRoutine)

    MOV  SS:[BX].regDs, DS          ; regTable.ds = SELECTOR (@osCurrentPid)

    MOV  SS:[BX].regSlot, 0FEH      ; current slot = null slot

    MOV  busyStackSeg, SS           ; start of busy's stack
    MOV  busyStackOff, BX           ; (!! IS THIS NEEDED - USED BY ANYONE ??)

    MOV  ES:pcbStackSeg, SS
    MOV  ES:pcbStackOff, BX         ; curPcb.stack := @regTable

    MOV  ES:pcbPriority, 254        ; curPcb.priority := 255

    MOV  WORD PTR ES:pcbPLoadTable, OFFSET fakeLoadTable
    MOV  WORD PTR ES:pcbPLoadTable+2, CS

    PUSH ES                         ; osCurrentPid
    CALL CpCreateProcess


; now create temporary looping process

; Both the pcb and the stack of the temporary looping process will be allocated
; together as one block.  They will be freed later (in Startup:Busy) as a unit.
; RegTable.ds is not being set because the loop process doesn't do anything
; except loop !

    XOR  AX, AX                     ; system pid
    PUSH AX
    MOV  AX, SIZE PcbType - dfltCntxtSize
    ADD  AX, emsContextSize
    ADD  AX, minStkSize
    PUSH AX
    MOV  AX, OFFSET dummyError
    PUSH DS
    PUSH AX
    CALL IntAllocate                ; Returns ES:BX => pcb and stack

    MOV  loopPid, ES                ; loopPid := loopPidConst

    MOV  DI, BX
    MOV  CX, SIZE PcbType - dfltCntxtSize
    MOV  AL, 0
    CLD                             ; set pcb to zero (except ems context)
    REP  STOSB                      ; ems context part is set in CpCreateProcess

    MOV  BX, SIZE PcbType - dfltCntxtSize
    ADD  BX, emsContextSize
    ADD  BX, minStkSize
    SUB  BX, SIZE RegTableType      ; ES:BX => pRegTable

    MOV  AX, OFFSET LoopProc
    MOV  ES:[BX].regCs, CS          ; regTable.cs = SELECTOR(@DoBoot)
    MOV  ES:[BX].regIp, AX          ; regTable.ip = OFFSETOF(@DoBoot)
    MOV  ES:[BX].regSlot, 0FEH      ; current slot = none

    MOV  ES:pcbStackSeg, ES
    MOV  ES:pcbStackOff, BX         ; curPcb.stack := @regTable

    MOV  ES:pcbPriority, 255        ; curPcb.priority := 255

    MOV  WORD PTR ES:pcbPLoadTable, OFFSET fakeLoadTable
    MOV  WORD PTR ES:pcbPLoadTable+2, CS

    PUSH ES                         ; osCurrentPid
    CALL CpCreateProcess


;   CALL Init87                     ; This call has been moved to Cp.Main.Asm

    MOV  AL, 1
    PUSH AX
    CALL CpSystemTick               ; CALL CpSystemTick(1)

    MOV  AX, goodBye                ; goodBye
    PUSH AX
    CALL Reschedule

;   POP  BP
;   POP  DS
;   RET
InitMultiTasking ENDP

PURGE pRoutineOff
PURGE pRoutineSeg


CODE ENDS

    END
